<?php

namespace Phiki\Grammar;

use Phiki\Contracts\GrammarRepositoryInterface;

// This file is automatically generated and should not be edited manually.
enum Grammar: string
{
    case Txt = 'txt';
    case Antlers = 'antlers';
    case Abap = 'abap';
    case Actionscript_3 = 'actionscript-3';
    case Ada = 'ada';
    case AngularHtml = 'angular-html';
    case AngularTs = 'angular-ts';
    case Apache = 'apache';
    case Apex = 'apex';
    case Apl = 'apl';
    case Applescript = 'applescript';
    case Ara = 'ara';
    case Asciidoc = 'asciidoc';
    case Asm = 'asm';
    case Astro = 'astro';
    case Awk = 'awk';
    case Ballerina = 'ballerina';
    case Bat = 'bat';
    case Beancount = 'beancount';
    case Berry = 'berry';
    case Bibtex = 'bibtex';
    case Blade = 'blade';
    case Bsl = 'bsl';
    case C = 'c';
    case Cadence = 'cadence';
    case Cairo = 'cairo';
    case Clarity = 'clarity';
    case Clojure = 'clojure';
    case Cmake = 'cmake';
    case Cobol = 'cobol';
    case Codeowners = 'codeowners';
    case Codeql = 'codeql';
    case Coffee = 'coffee';
    case CommonLisp = 'common-lisp';
    case Coq = 'coq';
    case Cpp = 'cpp';
    case Crystal = 'crystal';
    case Csharp = 'csharp';
    case Css = 'css';
    case Csv = 'csv';
    case Cue = 'cue';
    case Cypher = 'cypher';
    case D = 'd';
    case Dart = 'dart';
    case Dax = 'dax';
    case Desktop = 'desktop';
    case Diff = 'diff';
    case Docker = 'docker';
    case Dotenv = 'dotenv';
    case DreamMaker = 'dream-maker';
    case Edge = 'edge';
    case Elixir = 'elixir';
    case Elm = 'elm';
    case EmacsLisp = 'emacs-lisp';
    case Erb = 'erb';
    case Erlang = 'erlang';
    case Fennel = 'fennel';
    case Fish = 'fish';
    case Fluent = 'fluent';
    case FortranFixedForm = 'fortran-fixed-form';
    case FortranFreeForm = 'fortran-free-form';
    case Fsharp = 'fsharp';
    case Gdresource = 'gdresource';
    case Gdscript = 'gdscript';
    case Gdshader = 'gdshader';
    case Genie = 'genie';
    case Gherkin = 'gherkin';
    case GitCommit = 'git-commit';
    case GitRebase = 'git-rebase';
    case Gleam = 'gleam';
    case GlimmerJs = 'glimmer-js';
    case GlimmerTs = 'glimmer-ts';
    case Glsl = 'glsl';
    case Gnuplot = 'gnuplot';
    case Go = 'go';
    case Graphql = 'graphql';
    case Groovy = 'groovy';
    case Hack = 'hack';
    case Haml = 'haml';
    case Handlebars = 'handlebars';
    case Haskell = 'haskell';
    case Haxe = 'haxe';
    case Hcl = 'hcl';
    case Hjson = 'hjson';
    case Hlsl = 'hlsl';
    case Html = 'html';
    case HtmlDerivative = 'html-derivative';
    case Http = 'http';
    case Hxml = 'hxml';
    case Hy = 'hy';
    case Imba = 'imba';
    case Ini = 'ini';
    case Java = 'java';
    case Javascript = 'javascript';
    case Jinja = 'jinja';
    case Jison = 'jison';
    case Json = 'json';
    case Json5 = 'json5';
    case Jsonc = 'jsonc';
    case Jsonl = 'jsonl';
    case Jsonnet = 'jsonnet';
    case Jssm = 'jssm';
    case Jsx = 'jsx';
    case Julia = 'julia';
    case Kotlin = 'kotlin';
    case Kusto = 'kusto';
    case Latex = 'latex';
    case Lean = 'lean';
    case Less = 'less';
    case Liquid = 'liquid';
    case Llvm = 'llvm';
    case Log = 'log';
    case Logo = 'logo';
    case Lua = 'lua';
    case Luau = 'luau';
    case Make = 'make';
    case Markdown = 'markdown';
    case Marko = 'marko';
    case Matlab = 'matlab';
    case Mdc = 'mdc';
    case Mdx = 'mdx';
    case Mermaid = 'mermaid';
    case Mipsasm = 'mipsasm';
    case Mojo = 'mojo';
    case Move = 'move';
    case Narrat = 'narrat';
    case Nextflow = 'nextflow';
    case Nginx = 'nginx';
    case Nim = 'nim';
    case Nix = 'nix';
    case Nushell = 'nushell';
    case ObjectiveC = 'objective-c';
    case ObjectiveCpp = 'objective-cpp';
    case Ocaml = 'ocaml';
    case Pascal = 'pascal';
    case Perl = 'perl';
    case Php = 'php';
    case Plsql = 'plsql';
    case Polar = 'polar';
    case Postcss = 'postcss';
    case Powerquery = 'powerquery';
    case Powershell = 'powershell';
    case Prisma = 'prisma';
    case Prolog = 'prolog';
    case Proto = 'proto';
    case Pug = 'pug';
    case Puppet = 'puppet';
    case Purescript = 'purescript';
    case Python = 'python';
    case Qml = 'qml';
    case Qmldir = 'qmldir';
    case Qss = 'qss';
    case R = 'r';
    case Racket = 'racket';
    case Raku = 'raku';
    case Razor = 'razor';
    case Reg = 'reg';
    case Regexp = 'regexp';
    case Rel = 'rel';
    case Riscv = 'riscv';
    case Rst = 'rst';
    case Ruby = 'ruby';
    case Rust = 'rust';
    case Sas = 'sas';
    case Sass = 'sass';
    case Scala = 'scala';
    case Scheme = 'scheme';
    case Scss = 'scss';
    case Sdbl = 'sdbl';
    case Shaderlab = 'shaderlab';
    case Shellscript = 'shellscript';
    case Shellsession = 'shellsession';
    case Smalltalk = 'smalltalk';
    case Solidity = 'solidity';
    case Soy = 'soy';
    case Sparql = 'sparql';
    case Splunk = 'splunk';
    case Sql = 'sql';
    case SshConfig = 'ssh-config';
    case Stata = 'stata';
    case Stylus = 'stylus';
    case Svelte = 'svelte';
    case Swift = 'swift';
    case SystemVerilog = 'system-verilog';
    case Systemd = 'systemd';
    case Talonscript = 'talonscript';
    case Tasl = 'tasl';
    case Tcl = 'tcl';
    case Templ = 'templ';
    case Terraform = 'terraform';
    case Tex = 'tex';
    case Toml = 'toml';
    case TsTags = 'ts-tags';
    case Tsv = 'tsv';
    case Tsx = 'tsx';
    case Turtle = 'turtle';
    case Twig = 'twig';
    case Typescript = 'typescript';
    case Typespec = 'typespec';
    case Typst = 'typst';
    case V = 'v';
    case Vala = 'vala';
    case Vb = 'vb';
    case Verilog = 'verilog';
    case Vhdl = 'vhdl';
    case Viml = 'viml';
    case Vue = 'vue';
    case VueHtml = 'vue-html';
    case VueVine = 'vue-vine';
    case Vyper = 'vyper';
    case Wasm = 'wasm';
    case Wgsl = 'wgsl';
    case Wikitext = 'wikitext';
    case Wit = 'wit';
    case Wolfram = 'wolfram';
    case Xml = 'xml';
    case Xsl = 'xsl';
    case Yaml = 'yaml';
    case Zenscript = 'zenscript';
    case Zig = 'zig';

    public function aliases(): array
    {
        return match ($this) {
            self::Abap => [],
            self::Actionscript_3 => [],
            self::Ada => [],
            self::AngularHtml => [],
            self::AngularTs => [],
            self::Apache => [],
            self::Apex => [],
            self::Apl => [],
            self::Applescript => [],
            self::Ara => [],
            self::Asciidoc => ['adoc'],
            self::Asm => [],
            self::Astro => [],
            self::Awk => [],
            self::Ballerina => [],
            self::Bat => ['batch'],
            self::Beancount => [],
            self::Berry => ['be'],
            self::Bibtex => [],
            self::Blade => [],
            self::Bsl => ['1c'],
            self::C => [],
            self::Cadence => ['cdc'],
            self::Cairo => [],
            self::Clarity => [],
            self::Clojure => ['clj'],
            self::Cmake => [],
            self::Cobol => [],
            self::Codeowners => [],
            self::Codeql => ['ql'],
            self::Coffee => ['coffeescript'],
            self::CommonLisp => ['lisp'],
            self::Coq => [],
            self::Cpp => ['c++'],
            self::Crystal => [],
            self::Csharp => ['c#', 'cs'],
            self::Css => [],
            self::Csv => [],
            self::Cue => [],
            self::Cypher => ['cql'],
            self::D => [],
            self::Dart => [],
            self::Dax => [],
            self::Desktop => [],
            self::Diff => [],
            self::Docker => ['dockerfile'],
            self::Dotenv => [],
            self::DreamMaker => [],
            self::Edge => [],
            self::Elixir => [],
            self::Elm => [],
            self::EmacsLisp => ['elisp'],
            self::Erb => [],
            self::Erlang => ['erl'],
            self::Fennel => [],
            self::Fish => [],
            self::Fluent => ['ftl'],
            self::FortranFixedForm => ['f', 'for', 'f77'],
            self::FortranFreeForm => ['f90', 'f95', 'f03', 'f08', 'f18'],
            self::Fsharp => ['f#', 'fs'],
            self::Gdresource => [],
            self::Gdscript => [],
            self::Gdshader => [],
            self::Genie => [],
            self::Gherkin => [],
            self::GitCommit => [],
            self::GitRebase => [],
            self::Gleam => [],
            self::GlimmerJs => ['gjs'],
            self::GlimmerTs => ['gts'],
            self::Glsl => [],
            self::Gnuplot => [],
            self::Go => [],
            self::Graphql => ['gql'],
            self::Groovy => [],
            self::Hack => [],
            self::Haml => [],
            self::Handlebars => ['hbs'],
            self::Haskell => ['hs'],
            self::Haxe => [],
            self::Hcl => [],
            self::Hjson => [],
            self::Hlsl => [],
            self::Html => [],
            self::HtmlDerivative => [],
            self::Http => [],
            self::Hxml => [],
            self::Hy => [],
            self::Imba => [],
            self::Ini => ['properties'],
            self::Java => [],
            self::Javascript => ['js'],
            self::Jinja => [],
            self::Jison => [],
            self::Json => [],
            self::Json5 => [],
            self::Jsonc => [],
            self::Jsonl => [],
            self::Jsonnet => [],
            self::Jssm => ['fsl'],
            self::Jsx => [],
            self::Julia => ['jl'],
            self::Kotlin => ['kt', 'kts'],
            self::Kusto => ['kql'],
            self::Latex => [],
            self::Lean => ['lean4'],
            self::Less => [],
            self::Liquid => [],
            self::Llvm => [],
            self::Log => [],
            self::Logo => [],
            self::Lua => [],
            self::Luau => [],
            self::Make => ['makefile'],
            self::Markdown => ['md'],
            self::Marko => [],
            self::Matlab => [],
            self::Mdc => [],
            self::Mdx => [],
            self::Mermaid => ['mmd'],
            self::Mipsasm => ['mips'],
            self::Mojo => [],
            self::Move => [],
            self::Narrat => ['nar'],
            self::Nextflow => ['nf'],
            self::Nginx => [],
            self::Nim => [],
            self::Nix => [],
            self::Nushell => ['nu'],
            self::ObjectiveC => ['objc'],
            self::ObjectiveCpp => [],
            self::Ocaml => [],
            self::Pascal => [],
            self::Perl => [],
            self::Php => [],
            self::Plsql => [],
            self::Polar => [],
            self::Postcss => [],
            self::Powerquery => [],
            self::Powershell => ['ps', 'ps1'],
            self::Prisma => [],
            self::Prolog => [],
            self::Proto => ['protobuf'],
            self::Pug => ['jade'],
            self::Puppet => [],
            self::Purescript => [],
            self::Python => ['py'],
            self::Qml => [],
            self::Qmldir => [],
            self::Qss => [],
            self::R => [],
            self::Racket => [],
            self::Raku => ['perl6'],
            self::Razor => [],
            self::Reg => [],
            self::Regexp => ['regex'],
            self::Rel => [],
            self::Riscv => [],
            self::Rst => [],
            self::Ruby => ['rb'],
            self::Rust => ['rs'],
            self::Sas => [],
            self::Sass => [],
            self::Scala => [],
            self::Scheme => [],
            self::Scss => [],
            self::Sdbl => ['1c-query'],
            self::Shaderlab => ['shader'],
            self::Shellscript => ['bash', 'sh', 'shell', 'zsh'],
            self::Shellsession => ['console'],
            self::Smalltalk => [],
            self::Solidity => [],
            self::Soy => ['closure-templates'],
            self::Sparql => [],
            self::Splunk => ['spl'],
            self::Sql => [],
            self::SshConfig => [],
            self::Stata => [],
            self::Stylus => ['styl'],
            self::Svelte => [],
            self::Swift => [],
            self::SystemVerilog => [],
            self::Systemd => [],
            self::Talonscript => ['talon'],
            self::Tasl => [],
            self::Tcl => [],
            self::Templ => [],
            self::Terraform => ['tf', 'tfvars'],
            self::Tex => [],
            self::Toml => [],
            self::TsTags => ['lit'],
            self::Tsv => [],
            self::Tsx => [],
            self::Turtle => [],
            self::Twig => [],
            self::Typescript => ['ts'],
            self::Typespec => ['tsp'],
            self::Typst => ['typ'],
            self::V => [],
            self::Vala => [],
            self::Vb => ['cmd'],
            self::Verilog => [],
            self::Vhdl => [],
            self::Viml => ['vim', 'vimscript'],
            self::Vue => [],
            self::VueHtml => [],
            self::VueVine => [],
            self::Vyper => ['vy'],
            self::Wasm => [],
            self::Wgsl => [],
            self::Wikitext => ['mediawiki', 'wiki'],
            self::Wit => [],
            self::Wolfram => ['wl'],
            self::Xml => [],
            self::Xsl => [],
            self::Yaml => ['yml'],
            self::Zenscript => [],
            self::Zig => [],
            self::Antlers => [],
            self::Txt => ['plaintext', 'text', 'plain'],
        };
    }

    public function scopeName(): string
    {
        return match ($this) {
            self::Abap => 'source.abap',
            self::Actionscript_3 => 'source.actionscript.3',
            self::Ada => 'source.ada',
            self::AngularHtml => 'text.html.derivative.ng',
            self::AngularTs => 'source.ts.ng',
            self::Apache => 'source.apacheconf',
            self::Apex => 'source.apex',
            self::Apl => 'source.apl',
            self::Applescript => 'source.applescript',
            self::Ara => 'source.ara',
            self::Asciidoc => 'text.asciidoc',
            self::Asm => 'source.asm.x86_64',
            self::Astro => 'source.astro',
            self::Awk => 'source.awk',
            self::Ballerina => 'source.ballerina',
            self::Bat => 'source.batchfile',
            self::Beancount => 'text.beancount',
            self::Berry => 'source.berry',
            self::Bibtex => 'text.bibtex',
            self::Blade => 'text.html.php.blade',
            self::Bsl => 'source.bsl',
            self::C => 'source.c',
            self::Cadence => 'source.cadence',
            self::Cairo => 'source.cairo0',
            self::Clarity => 'source.clar',
            self::Clojure => 'source.clojure',
            self::Cmake => 'source.cmake',
            self::Cobol => 'source.cobol',
            self::Codeowners => 'text.codeowners',
            self::Codeql => 'source.ql',
            self::Coffee => 'source.coffee',
            self::CommonLisp => 'source.commonlisp',
            self::Coq => 'source.coq',
            self::Cpp => 'source.cpp',
            self::Crystal => 'source.crystal',
            self::Csharp => 'source.cs',
            self::Css => 'source.css',
            self::Csv => 'text.csv',
            self::Cue => 'source.cue',
            self::Cypher => 'source.cypher',
            self::D => 'source.d',
            self::Dart => 'source.dart',
            self::Dax => 'source.dax',
            self::Desktop => 'source.desktop',
            self::Diff => 'source.diff',
            self::Docker => 'source.dockerfile',
            self::Dotenv => 'source.dotenv',
            self::DreamMaker => 'source.dm',
            self::Edge => 'text.html.edge',
            self::Elixir => 'source.elixir',
            self::Elm => 'source.elm',
            self::EmacsLisp => 'source.emacs.lisp',
            self::Erb => 'text.html.erb',
            self::Erlang => 'source.erlang',
            self::Fennel => 'source.fnl',
            self::Fish => 'source.fish',
            self::Fluent => 'source.ftl',
            self::FortranFixedForm => 'source.fortran.fixed',
            self::FortranFreeForm => 'source.fortran.free',
            self::Fsharp => 'source.fsharp',
            self::Gdresource => 'source.gdresource',
            self::Gdscript => 'source.gdscript',
            self::Gdshader => 'source.gdshader',
            self::Genie => 'source.genie',
            self::Gherkin => 'text.gherkin.feature',
            self::GitCommit => 'text.git-commit',
            self::GitRebase => 'text.git-rebase',
            self::Gleam => 'source.gleam',
            self::GlimmerJs => 'source.gjs',
            self::GlimmerTs => 'source.gts',
            self::Glsl => 'source.glsl',
            self::Gnuplot => 'source.gnuplot',
            self::Go => 'source.go',
            self::Graphql => 'source.graphql',
            self::Groovy => 'source.groovy',
            self::Hack => 'source.hack',
            self::Haml => 'text.haml',
            self::Handlebars => 'text.html.handlebars',
            self::Haskell => 'source.haskell',
            self::Haxe => 'source.hx',
            self::Hcl => 'source.hcl',
            self::Hjson => 'source.hjson',
            self::Hlsl => 'source.hlsl',
            self::Html => 'text.html.basic',
            self::HtmlDerivative => 'text.html.derivative',
            self::Http => 'source.http',
            self::Hxml => 'source.hxml',
            self::Hy => 'source.hy',
            self::Imba => 'source.imba',
            self::Ini => 'source.ini',
            self::Java => 'source.java',
            self::Javascript => 'source.js',
            self::Jinja => 'source.jinja',
            self::Jison => 'source.jison',
            self::Json => 'source.json',
            self::Json5 => 'source.json5',
            self::Jsonc => 'source.json.comments',
            self::Jsonl => 'source.json.lines',
            self::Jsonnet => 'source.jsonnet',
            self::Jssm => 'source.jssm',
            self::Jsx => 'source.js.jsx',
            self::Julia => 'source.julia',
            self::Kotlin => 'source.kotlin',
            self::Kusto => 'source.kusto',
            self::Latex => 'text.tex.latex',
            self::Lean => 'source.lean4',
            self::Less => 'source.css.less',
            self::Liquid => 'text.html.liquid',
            self::Llvm => 'source.llvm',
            self::Log => 'text.log',
            self::Logo => 'source.logo',
            self::Lua => 'source.lua',
            self::Luau => 'source.luau',
            self::Make => 'source.makefile',
            self::Markdown => 'text.html.markdown',
            self::Marko => 'text.marko',
            self::Matlab => 'source.matlab',
            self::Mdc => 'text.markdown.mdc.standalone',
            self::Mdx => 'source.mdx',
            self::Mermaid => 'markdown.mermaid.codeblock',
            self::Mipsasm => 'source.mips',
            self::Mojo => 'source.mojo',
            self::Move => 'source.move',
            self::Narrat => 'source.narrat',
            self::Nextflow => 'source.nextflow',
            self::Nginx => 'source.nginx',
            self::Nim => 'source.nim',
            self::Nix => 'source.nix',
            self::Nushell => 'source.nushell',
            self::ObjectiveC => 'source.objc',
            self::ObjectiveCpp => 'source.objcpp',
            self::Ocaml => 'source.ocaml',
            self::Pascal => 'source.pascal',
            self::Perl => 'source.perl',
            self::Php => 'source.php',
            self::Plsql => 'source.plsql.oracle',
            self::Polar => 'source.polar',
            self::Postcss => 'source.css.postcss',
            self::Powerquery => 'source.powerquery',
            self::Powershell => 'source.powershell',
            self::Prisma => 'source.prisma',
            self::Prolog => 'source.prolog',
            self::Proto => 'source.proto',
            self::Pug => 'text.pug',
            self::Puppet => 'source.puppet',
            self::Purescript => 'source.purescript',
            self::Python => 'source.python',
            self::Qml => 'source.qml',
            self::Qmldir => 'source.qmldir',
            self::Qss => 'source.qss',
            self::R => 'source.r',
            self::Racket => 'source.racket',
            self::Raku => 'source.perl.6',
            self::Razor => 'text.aspnetcorerazor',
            self::Reg => 'source.reg',
            self::Regexp => 'source.regexp.python',
            self::Rel => 'source.rel',
            self::Riscv => 'source.riscv',
            self::Rst => 'source.rst',
            self::Ruby => 'source.ruby',
            self::Rust => 'source.rust',
            self::Sas => 'source.sas',
            self::Sass => 'source.sass',
            self::Scala => 'source.scala',
            self::Scheme => 'source.scheme',
            self::Scss => 'source.css.scss',
            self::Sdbl => 'source.sdbl',
            self::Shaderlab => 'source.shaderlab',
            self::Shellscript => 'source.shell',
            self::Shellsession => 'text.shell-session',
            self::Smalltalk => 'source.smalltalk',
            self::Solidity => 'source.solidity',
            self::Soy => 'text.html.soy',
            self::Sparql => 'source.sparql',
            self::Splunk => 'source.splunk_search',
            self::Sql => 'source.sql',
            self::SshConfig => 'source.ssh-config',
            self::Stata => 'source.stata',
            self::Stylus => 'source.stylus',
            self::Svelte => 'source.svelte',
            self::Swift => 'source.swift',
            self::SystemVerilog => 'source.systemverilog',
            self::Systemd => 'source.systemd',
            self::Talonscript => 'source.talon',
            self::Tasl => 'source.tasl',
            self::Tcl => 'source.tcl',
            self::Templ => 'source.templ',
            self::Terraform => 'source.hcl.terraform',
            self::Tex => 'text.tex',
            self::Toml => 'source.toml',
            self::TsTags => 'source.ts.tags',
            self::Tsv => 'text.tsv',
            self::Tsx => 'source.tsx',
            self::Turtle => 'source.turtle',
            self::Twig => 'text.html.twig',
            self::Typescript => 'source.ts',
            self::Typespec => 'source.tsp',
            self::Typst => 'source.typst',
            self::V => 'source.v',
            self::Vala => 'source.vala',
            self::Vb => 'source.asp.vb.net',
            self::Verilog => 'source.verilog',
            self::Vhdl => 'source.vhdl',
            self::Viml => 'source.viml',
            self::Vue => 'source.vue',
            self::VueHtml => 'text.html.vue-html',
            self::VueVine => 'source.vue-vine',
            self::Vyper => 'source.vyper',
            self::Wasm => 'source.wat',
            self::Wgsl => 'source.wgsl',
            self::Wikitext => 'source.wikitext',
            self::Wit => 'source.wit',
            self::Wolfram => 'source.wolfram',
            self::Xml => 'text.xml',
            self::Xsl => 'text.xml.xsl',
            self::Yaml => 'source.yaml',
            self::Zenscript => 'source.zenscript',
            self::Zig => 'source.zig',
            self::Antlers => 'text.html.statamic',
            self::Txt => 'text.plain'
        };
    }

    public function path(): string
    {
        return __DIR__."/../../resources/grammars/{$this->value}.json";
    }

    public static function parse(array $grammar): ParsedGrammar
    {
        return (new GrammarParser)->parse($grammar);
    }

    public function toParsedGrammar(GrammarRepositoryInterface $repository): ParsedGrammar
    {
        return $repository->get($this->value);
    }
}
